<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tblregistros', function (Blueprint $table) {
            $table->id('lRegistro_id');
            $table->date('dtRegistro')->nullable();
            $table->unsignedBigInteger('lGestion_id');
            $table->unsignedBigInteger('lEstudiante_id');
            $table->unsignedBigInteger('lGrupo_id');
            $table->tinyInteger('boolEstado')->default(1);
            $table->timestamps();
            $table->foreign('lEstudiante_id')->references('lEstudiante_id')->on('tblEstudiantes');
            $table->foreign('lGrupo_id')->references('lGrupo_id')->on('tblGrupos');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tblregistros');
    }
};
