<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Validation\Rules\Unique;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tblestudiantes', function (Blueprint $table) {
            $table->id('lEstudiante_id');
            $table->string('sCodigo', 10)->nullable();
            $table->string('sNombre', 200);
            $table->string('sApellido', 200);
            $table->unsignedBigInteger('lUNegocio_id');
            $table->string('sEmail', 50)->unique();
            $table->string('sPassword', 200);
            $table->string('sFoto',50)->nullable();
            $table->tinyInteger('boolEstado')->default(1);            
            $table->timestamps();

            $table->foreign('lUNegocio_id')->references('lUNegocio_id')->on('tblUNegocios');
        
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tblestudiantes');
    }
};
