<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tblunegocios', function (Blueprint $table) {
            $table->id('lUNegocio_id');
            $table->string('sDescripcion', 200)->nullable();
            $table->tinyInteger('boolEstado')->default(1);
            $table->string('sCodigo', 10)->unique();
            $table->tinyInteger('lTurno')->default(1);
            $table->tinyInteger('lNivel')->default(1);
            $table->tinyInteger('lCiudad')->default(1);
            $table->string('sDireccion', 100)->nullable();
            $table->string('sFono', 100)->nullable();
            $table->string('sLogo', 100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tblunegocios');
    }
};
