<?php

namespace App\Providers;

use App\Models\Estudiante;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use JeroenNoten\LaravelAdminLte\Events\BuildingMenu;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        Event::listen(BuildingMenu::class, function (BuildingMenu $event) {
            // Add some items to the menu...
            $event->menu->add('ESTADISTICOS');
            $conteo= Estudiante::all()->where('boolEstado'  ,'=','1')
                                      ->where('lUNegocio_id','=', session('UNegocioID'))
                                      ->count(); //->get();
            $event->menu->add([
                'text' => 'Estudiantes', 
                'route' => 'estudiantes.index', 
                'icon'=> 'far fa-fw fa-file',
                'label' =>  $conteo,
                'label_color' =>'success']);
        });
        /** para leer desde la base de datos
           $event->menu->add(trans('menu.pages'));
            $items = Page::all()->map(function (Page $page) {
                return [
                    'text' => $page['title'],
                    'url' => route('admin.pages.edit', $page)
                ];
            });
            $event->menu->add(...$items);
        });
         */
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
