<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class rptGeneral extends Model
{
    //use HasFactory;
    // Función para obtener los datos del reporte
    public static function generateReportData($plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto)
    {
        return DB::select("
            SELECT t.lNroTransaccion, t.dtTransaccion, t.sCliente, SUM(dt.lSubTotal) lTotal, t.lEstado, fParametros(t.lEstado, 7) sEstado, 
            fParametros(t.lTipo,1) sTipo, fNomGestion(t.lGestion_id) sGestion
            FROM tbltransacciones t, tbldtransacciones dt
            WHERE t.lGestion_id = ? AND t.lUNegocio_id = ?                 
                AND t.dtTransaccion BETWEEN ? AND ?
                AND t.lTipo = ?                
                AND t.lTransaccion_id = dt.lTransaccion_id
            GROUP BY t.lNroTransaccion, t.dtTransaccion, t.sCliente, t.lEstado, fParametros(t.lEstado, 7), fParametros(t.lTipo,1), fNomGestion(t.lGestion_id)
            ORDER BY t.lNroTransaccion
        ",[$plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto]);
    }
    public static function totalesReporte($plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto)
    {
        return DB::select("
            SELECT t.lEstado, fParametros(t.lEstado, 7) sEstado, sum(dt.lSubTotal) lTotal
            FROM tbltransacciones t, tbldtransacciones dt
            WHERE t.lGestion_id = ? AND t.lUNegocio_id = ?                 
                AND t.dtTransaccion BETWEEN ? AND ?
                AND t.lTipo = ?                 
                AND t.lTransaccion_id = dt.lTransaccion_id
            GROUP BY t.lEstado, fParametros(t.lEstado, 7)            
        ",[$plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto]);
        
    }
}
