<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Registro extends Model
{
    protected $table = 'tblregistros';

    protected $primaryKey = 'lRegistro_id';

    protected $fillable = [
        'dtRegistro',
        'lGestion_id',
        'lEstudiante_id',
        'lGrupo_id',
        'boolEstado',
    ];

    public function estudiante()
    {
        return $this->belongsTo(Estudiante::class, 'lEstudiante_id');
    }

    public function curso()
    {
        return $this->belongsTo(Curso::class, 'lCurso_id');
    }
}