<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Estudiante extends Model
{
    protected $table = 'tblestudiantes';

    protected $primaryKey = 'lEstudiante_id';

    protected $fillable = [
        'sCodigo',
        'sNombre',
        'sApellidos',
        'lUNegocio_id',
        'sEmail',
        'sPassword',
        'sFoto',
        'boolEstado',        
    ];

    public function uNegocio()
    {
        return $this->belongsTo(UNegocio::class, 'lUNegocio_id');
    }
}