<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DTransaccion extends Model
{
    protected $table = 'tbldtransacciones';

    protected $primaryKey = 'lDTransaccion_id';

    protected $fillable = [
        'lMonto',
        'lCantidad',
        'lSubTotal',
        'lTransaccion_id',
        'lDConcepto_id',
    ];

    public function transaccion()
    {
        return $this->belongsTo(Transaccion::class, 'lTransaccion_id');
    }

    public function dConcepto()
    {
        return $this->belongsTo(DConcepto::class, 'lDConcepto_id');
    }
}
