<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DConcepto extends Model
{
    protected $table = 'tbldconceptos';

    protected $primaryKey = 'lDConcepto_id';

    protected $fillable = [
        'lMonto',
        'lTipoDConcepto',
        'lGestion_id',
        'lConcepto_id',
        'lUNegocio_id',
    ];

    public function gestion()
    {
        return $this->belongsTo(Gestion::class, 'lGestion_id');
    }

    public function concepto()
    {
        return $this->belongsTo(Concepto::class, 'lConcepto_id');
    }

    public function uNegocio()
    {
        return $this->belongsTo(UNegocio::class, 'lUNegocio_id');
    }
}