<?php

namespace App\Http\Controllers;

use App\Models\rptGeneral;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Support\Facades\DB;

class rptGeneralController extends Controller
{
    public function index()
    {           
        $cboTipoTransacciones = DB::select("call pvalGrupos(1,'lTipo',6)");         
        $cboGestiones = DB::select('call pGestiones(0,null,null,null,1,null,null,4)');
        $cboUNegocios = DB::select('call pUNegocios(0,null,1,null,null,null,null,null,null,null,4)');
        $cboConceptos = DB::select('call pDconceptos(0,null,null,?,0,?,6)',[session('GestionID'),session('UNegocioID')]);
        return view('reports.index', compact('cboTipoTransacciones','cboGestiones','cboUNegocios','cboConceptos'));
        
    }
    public function reporte($plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto)
    {
        $unegocios = DB::select('call pUnegocios (?,null,null,null,null,null,null,null,null,null,5)',[session('UNegocioID')]);    
        $data = rptGeneral::generateReportData($plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto); 
                                              //1,1,'2024-01-01','2024-12-31',1);
        $totales = rptGeneral::totalesReporte($plGestionID, $plUNegocioID, $pFInicial, $pFFinal, $pTipoConcepto);        
        $pFInicial = \DateTime::createFromFormat('Y-m-d', $pFInicial)->format('d/m/Y');
        $pFFinal = \DateTime::createFromFormat('Y-m-d', $pFFinal)->format('d/m/Y');
        $pdf = PDF:: loadView('reports.rptGeneral_pdf', compact('data', 'unegocios','pFInicial','pFFinal','totales'));
        //return $pdf->download('reporte.pdf');
        return $pdf->stream(); 
    }
}
