<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB; 
use App\Models\ValGrupo;
use App\Models\ValParametro;
use Illuminate\Http\Request;

class ValParametroController extends Controller
{
    public function index(Request $request)
    {  
        $grupo_id =  $request->flGrupo_id;            
        $valgrupos = ValGrupo::all('*');        

        $valparametro = DB::select('call pParametros(0,null,null,?,null,?)',[$grupo_id == null ? null:$grupo_id, $grupo_id == null ? 4:6]);// ValParametro::all();
        //dd($valparametro);
        //$valparametro = ValParametro::paginate(5);
        //{{$valparametro->links()}}  al final de la tabla index.blade.php
        //{{$valparametro->appends(['filtrar'=>$grupo_id])}}  al final de la tabla index.blade.php para filtrar solo las busquedas
        return view('valparametros.index', compact('valparametro','valgrupos', 'grupo_id'));        
    }
    public function create()
    {
        $valgrupos = ValGrupo::all('*'); //DB::select('call pGrupos(0,null,4)'); //ValGrupo::all();  //        
        return view('valparametros.create', compact('valgrupos'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo concepto en la base de datos   
        $request->validate([                      
            'sParametro' => 'required',
            'lGrupo_id'=>'required',
        ]);      
        $valparametro = DB::select('call pParametros (0,0,?,?,1,1)',             
            [$request->input('sParametro'), 
            $request->input('lGrupo_id')
        ]);        
        return redirect()->route('valparametros.index')
                        ->with('success','Parametro CREADO correctamente.');        
    }

    public function show($id)
    {
        //$valparametro = ValParametro::find(decrypt($id));        
        $valparametro = DB::select('call pParametros(?,null,null,null,null,5)',[decrypt($id)]);
        return view('valparametros.show', compact('valparametro'));
    }

    public function edit($id)
    {
        //$valparametro = ValParametro::find(decrypt($id)); 
        $valgrupos = ValGrupo::all('*');              
        $valparametro = DB::select('call pParametros(?,null,null,null,null,5)',[decrypt($id)]);
        return view('valparametros.edit', compact('valparametro', 'valgrupos'));
    }

    public function update(Request $request)
    {
        // Lógica para actualizar una transacción en la base de datos
        DB::select('call pParametros(?,?,?,?,?,2)', 
            [$request->input('lParametro_id'),
            $request->input('lValue_id'),
            $request->input('sParametro'),
            $request->input('lGrupo_id'),
            ($request->input('boolEstado')? 1 : 0)
            ]);
        return redirect()->route('valparametros.index')
            ->with('success','Parametro ACTUALIZADO correctamente');
    }

    public function destroy($id)
    {
        // Lógica para eliminar una transacción de la base de datos
        DB::select('call pParametros(?,null,null,null,null,3)',[$id]);
        $valparametro = DB::select('call pParametros(0,null,null,null,null,4)');
        return view('valparametros.index', compact('valparametro'));        
    }
    public function filtrar($id)
    {
        $valgrupos = ValGrupo::all('*'); 
        $valparametro = DB::select('call pParametros(0,null,null,?,null,6)',[$id]);// ValParametro::all();
        return view('valparametros.index', compact('valparametro','valgrupos'));
    }
}
