<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use App\Models\ValGrupo;
use Illuminate\Http\Request;

class ValGrupoController extends Controller
{
    public function index()
    {
        $valgrupos = DB::select('call pvalGrupos(0,null,4)'); // ValGrupo::all(); 
        $valgrupos = ValGrupo::paginate(7);
        return view('valgrupos.index', compact('valgrupos'));
    }

    public function create()
    {
        return view('valgrupos.create');
    }

    public function store(Request $request)
    {
        // Lógica para almacenar una nueva transacción en la base de datos
        $request->validate([                      
            'sGrupo' => 'required',            
        ]);     
        $valGrupo = DB::select('call pvalGrupos(0,?,1)',[$request->input('sGrupo')]);          
        return redirect()->route('valgrupos.index') -> with('success', 'Grupo creada correctamente');        
    }

    public function show($id)
    {        
        $valgrupo = ValGrupo::find(decrypt($id));
        return view('valGrupos.show', compact('valgrupo'));
    }

    public function edit($id)
    {
        $valgrupo = ValGrupo::find(decrypt($id));
        return view('valgrupos.edit', compact('valgrupo'));
    }

    public function update(Request $request)
    {        
        // Lógica para actualizar una transacción en la base de datos
        DB::select('call pvalGrupos(?,?,2)',
        [$request->input('lGrupo_id'),
        $request->input('sGrupo')]);
        return redirect()->route('valgrupos.index')->with('success','Grupo Actualizado');
    }

    public function destroy($id)
    {
        // Lógica para eliminar una transacción de la base de datos
        DB::select('call pvalGrupos(?,null,3)',[$id]);
        $valgrupos = DB::select('call pGrupos(0,null,4)');
        return view('valgrupos.index', compact('valgrupos'));
    }
}
