<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB; 
use App\Models\UNegocio;
use Illuminate\Http\Request;

class UNegocioController extends Controller
{
    public function index()
    {        
        $unegocios = DB::select('call pUnegocios (0,null,null,null,null,null,null,null,null,null,4)'); //UNegocio::all();        
        return view('unegocios.index', compact('unegocios'));
    }

    public function create()
    {
        $cboTurnos = DB::select("call pvalGrupos(8,'lTurno',6)");
        $cboNiveles= DB::select("call pvalGrupos(2,'lNivel',6)");
        $cboCiudades= DB::select("call pvalGrupos(9,'lCiudad',6)");
        return view('unegocios.create', compact('cboTurnos', 'cboNiveles','cboCiudades'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo negocio en la base de datos |max:6,Rule::unique("UNegocios")', 
        $request->validate([                      
            'sDescripcion' => 'required',
            'lTurno' => 'required',
            'lNivel' => 'required',
            'lCiudad'=> 'required',            
        ]);
        // Scrip para subir o mover imagen        
        if ($request->hasFile("sLogo")){
            $imagen = $request->file("sLogo");            
            $nombreimagen = 'udn'.date("mdHis") .'.'. $imagen->guessExtension();            
            $ruta = public_path("img/unegocio/");
            copy($imagen->getRealPath(),$ruta.$nombreimagen);
            $logo = $nombreimagen;
        }
        else{$logo = 'default.jpeg';}      

        DB::select('call pUnegocios (0,?,1,null,?,?,?,?,?,?,1)',[
            $request->input('sDescripcion'), $request->input('lTurno'),$request->input('lNivel'),
            $request->input('lCiudad'), $request->input('sDireccion'),$request->input('sFono'), $logo,
        ]);        
        return redirect()->route('unegocios.index')
                        ->with('success','Unidad creada correctamente.');
    }

    public function show($id)
    {
        $unegocio = DB::select('call pUnegocios (?,null,null,null,null,null,null,null,null,null,5)',[decrypt($id)]);//  UNegocio::find(decrypt($id));          
        return view('unegocios.show', compact('unegocio'));
    }

    public function edit($id)
    {
        //$unegocio=UNegocio::findOrFail($unegocio);
        $cboTurnos = DB::select("call pvalGrupos(8,'lTurno',6)");
        $cboNiveles= DB::select("call pvalGrupos(2,'lNivel',6)");
        $cboCiudades= DB::select("call pvalGrupos(9,'lCiudad',6)");
        $unegocio=UNegocio::find(decrypt($id));
        return view('unegocios.edit', compact('unegocio', 'cboTurnos', 'cboNiveles','cboCiudades'));
    }

    public function update(Request $request)
    {        
        $request->validate([                      
            'lUNegocio_id' => 'required',
            'sDescripcion' => 'required',
            'lTurno' => 'required',
            'lNivel' => 'required',
        ]);
        // Lógica para actualizar un negocio en la base de datos         
        if ($request->hasFile("sLogo")){
            $imagen = $request->file("sLogo");
            if ($request->input('sFoto')=='default.jpeg'){$nombreimagen = 'udn'.date("mdHis") .'.'. $imagen->guessExtension(); }
            else{$nombreimagen = $request->input('sFoto');}            
            $ruta = public_path("img/unegocio/");
            copy($imagen->getRealPath(),$ruta.$nombreimagen);
            $logo = $nombreimagen;
        }
        else {$logo=Null;}                  
        DB::select('call pUnegocios (?,?,?,?,?,?,?,?,?,?,2)',
                [$request->input('lUNegocio_id'),
                $request->input('sDescripcion'),
                ($request->input('boolEstado')? 1 : 0),
                $request->input('sCodigo'),
                $request->input('lTurno'),
                $request->input('lNivel'),
                $request->input('lCiudad'),
                $request->input('sDireccion'),
                $request->input('sFono'),
                $logo,
            ]); 
        
        return redirect()->route('unegocios.index')
                        ->with('success','Unidades actualizadas.');
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar un negocio de la base de datos
        DB::select('call pUnegocios(?,null,null,null,null,null,null,null,null,null,3)',[$id]);        
        return($this->index()); 
    }
}