<?php

namespace App\Http\Controllers;

use App\Models\Transaccion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf as PDF; 

class TransaccionController extends Controller
{
    public function index( Request $request)
    {
        $NroTransaccion = $request->flNroTransaccion;
        $transacciones = DB::select('call pTransacciones(0,?,null,null,null,null,null,null,?,?,null,?)',[$NroTransaccion == null ? null:$NroTransaccion, session('GestionID'), session('UNegocioID'), $NroTransaccion == null ? 4:7]);
        //$transacciones = Transaccion::where('lGestion_id', '=', session('GestionID'))->where('lUNegocio_id','=', session('UNegocio'))->orderByDesc('dtTransaccion')->get();
        //$transacciones = $transacciones->paginate(5);
        //dd($transacciones); //->orderBy('dtTransaccion','ASC') ->get() 
        return view('transacciones.index', compact('transacciones'));
    }

    public function create(Request $request)
    {
        $cboTipoTransacciones = DB::select("call pvalGrupos(1,'lTipo',6)");        
        //$cboRegistros = DB::select("call pRegistros(0,null,?,null,?,null,null,6)",[session('GestionID'),session('UNegocioID')]); //hay que reemplazar 1 por lagestion vigente
        $cboGestiones = DB::select('call pGestiones(0,null,null,null,1,null,null,4)');
        $cboUNegocios = DB::select('call pUNegocios(0,null,1,null,null,null,null,null,null,null,4)');
        $cboConceptos = DB::select('call pDconceptos(0,null,null,?,0,?,6)',[session('GestionID'),session('UNegocioID')]); //Hay que cambiar 1 gestion, 1 UNEgocio
        
        $ValorBusqueda = $request->rfid;
        //$estudiantes = DB::select('call pEstudiantes(0,null,?,null,?,null,null,null,null,null,null,?)',[$ValorBusqueda == null ? null:$ValorBusqueda, (int)session('UNegocioID'), $ValorBusqueda == null ? 4:7]);//Estudiante::all();
        $cboRegistros = DB::select('call pRegistros(0,null,?,null,?,null,?,7)',[session('GestionID'), session('UNegocioID'),$ValorBusqueda]);
        //return view('estudiantes.index', compact('estudiantes'));

        return view('transacciones.create', compact('cboTipoTransacciones','cboRegistros','cboGestiones','cboUNegocios','cboConceptos'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar una nueva transacción en la base de datos
        $request->validate([                                  
            'lTipo'=> 'required',
            'sCliente'=> 'required',
            'lRegistro_id'=> 'required',
            'lGestion_id'=> 'required',
            'lUNegocio_id'=> 'required',
            'sGlosa'=> 'required',
        ]);          
        dd($request); 
        DB::select('call pTransacciones (0,0,now(),?,?,0,1,?,?,?,?,1)',
        [$request->input('lTipo'), $request->input('sCliente'), 
        $request->input('lRegistro_id'), 0, $request->input('lGestion_id'), 1, $request->input('lUNegocio_id'),
        $request->input('sGlosa') ]);        
        return redirect()->route('transacciones.index')
                        ->with('success','Transaccion CREADO correctamente.');
    }

    public function show($id)
    {
        $transacciones = DB::select('call pTransacciones (?,null,null,null,null,null,null,null,null,null,null,6)', [decrypt($id)]);
        return view('transacciones.show', compact('transacciones'));
    }
    public function reporte($id)
    {           
        $unegocios = DB::select('call pUnegocios (?,null,null,null,null,null,null,null,null,null,5)',[session('UNegocioID')]);
        $transacciones = DB::select('call pTransacciones (?,null,null,null,null,null,null,null,null,null,null,6)', [decrypt($id)]);
        $pdf= PDF:: loadView('transacciones.reporte', compact('transacciones','unegocios'));
        return $pdf->stream(); 
    }

    public function edit(Transaccion $transaccion)
    {
        //Una transaccion no es puede editar solo imprimir SHOW y ANULAR
        return view('transacciones.edit', compact('transaccion'));
    }

    public function update(Request $request, Transaccion $transaccion)
    {
        // Lógica para actualizar una transacción en la base de datos
        // Una transaccion no se puede Actualizar
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar una transacción de la base de datos Borrado Fisico
        /**
         * $Borrado Logico anulamos la transaccion
         */
        DB::select('call pTransacciones (?,null,null,null,null,null,null,null,null,null,null,3)', [($id)]);
        return($this->index($request));
    }
}