<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use App\Models\Registro;
use App\Models\Gestion;
use App\Models\Grupo;
use App\Models\Estudiante;
use Illuminate\Http\Request;

class RegistroController extends Controller
{
    public function index(Request $request)
    {
        $ValorBusqueda = $request->flBuscar;
        $registros = DB::select('call pRegistros(0,null,?,null,?,null,?,?)',[session('GestionID'),session('UNegocioID'),$ValorBusqueda == null ? null:$ValorBusqueda,$ValorBusqueda == null ? 4:7]); //Registro::all();
        return view('registros.index', compact('registros'));        
    }

    public function create()
    { 
        $cboGestiones = Gestion::where('boolEstado','=',1)->where('lGestion_id','=',session('GestionID'))->orderBy('sGestion','ASC') ->get();
        $cboGrupos = DB::select('call pGrupos(0,0,?,0,0,0,0,0,?,0,4)',[session('GestionID'),session('UNegocioID')]);  //Grupo::where('boolEstado','=',1)->get();
        $cboEstudiantes = Estudiante::all()->where('boolEstado','=','0')->where('lUNegocio_id','=',session('UNegocioID'))->sortBy('sApellido'); //sortByDesc
        
        return view('registros.create', compact('cboGestiones', 'cboGrupos', 'cboEstudiantes'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo registro en la base de datos
        $request->validate([
            'lGestion_id'=>'required',
            'lEstudiante_id'=>'required',
            'lGrupo_id'=>'required',
        ]);
        DB::select('call pRegistros(0,now(),?,?,?,1,null,1)',[$request->input('lGestion_id'),
        $request->input('lEstudiante_id'), $request->input('lGrupo_id')]);
        return redirect()->route('registros.index') ->with('success','Registro Creado correctamente');        
    }

    public function show($id)
    {
        $registros = DB::select('call pRegistros(?,null,null,null,null,null,null,5)',[decrypt($id)]);
        return view('registros.show', compact('registros'));
    }

    public function edit($id)
    {
        $cboGestiones = Gestion::where('boolEstado','=',1)->where('lGestion_id','=',session('GestionID'))->get();
        $cboGrupos = Grupo::where('boolEstado','=',1)->where('lUNegocio_id','=',session('UNegocioID')) ->get();
        $cboEstudiantes = Estudiante::all();
        $registros = Registro::find([decrypt($id)]);
        return view('registros.edit', compact('registros','cboGestiones', 'cboGrupos','cboEstudiantes'));
    }

    public function update(Request $request)
    {
        // Lógica para actualizar un registro en la base de datos
        $request->validate([
            'lRegistro_id'=>'required',
            'dtRegistro'=>'required',
            'lGestion_id'=>'required',
            'lEstudiante_id'=>'required',
            'lGrupo_id'=>'required',
            'boolEstado'=>'required',
        ]);
        DB::select('call pRegistros(?,?,?,?,?,?,null,2)',[$request->input('lRegistro_id'), $request->input('dtRegistro'),$request->input('lGestion_id'),
            $request->input('lEstudiante_id'), $request->input('lGrupo_id'), $request->input('boolEstado')]);
        return redirect()->route('registros.index') ->with('success','Registro Modificado correctamente');
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar un registro de la base de datos
        DB::select('call pRegistros(?,null,null,null,null,null,null,3)', [$id]);
        return($this->index($request));
    }
    public function register()
    { 
        $cboGestiones = Gestion::where('boolEstado','=',1)->orderBy('sGestion','ASC') ->get();
        $cboGrupos = DB::select('call pGrupos(0,0,0,0,0,0,0,0,0,0,4)');  //Grupo::where('boolEstado','=',1)->get();
        $cboEstudiantes = Estudiante::all()->where('boolEstado','=','0')->sortBy('sApellido'); //sortByDesc
        
        return view('registros.create', compact('cboGestiones', 'cboGrupos', 'cboEstudiantes'));
    }
}