<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB; 
use App\Models\Grupo;
use App\Models\Gestion;
use App\Models\Curso;
use App\Models\UNegocio;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf as PDF;

class GrupoController extends Controller
{
    public function index(Request $request)
    {
        //$algo = new Grupo; para declara uan variable detipo Grupo
        //$algo->create($request->all());
        $nivel =  $request->flNivel;         
        $combobox = DB::select("call pvalGrupos(2,'lNivel',6)");  
        $grupos = DB::select('call pGrupos(0, null, ?, null,null,null, null, null, ?, ?, ?)',[session('GestionID'), session('UNegocioID'), $nivel == null ? null:$nivel, $nivel == null ? 4:6]);// Grupo::all();
        return view('grupos.index', compact('grupos','combobox', 'nivel'));
    }
    public function create()
    {
        $combobox = DB::select("call pvalGrupos(2,'lNivel',6)"); //ValGrupo::all(); //         
        $cboGestiones = Gestion::where('boolEstado','=',1)->get(); //Gestion::all();
        $cboCursos = Curso::all();
        $cboUNegocios = UNegocio::where('boolEstado','=',1)->get();        
        return view('grupos.create', compact('combobox','cboGestiones','cboCursos','cboUNegocios'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo grupo en la base de datos
               
        $request->validate([                      
            'sGrupo' => 'required',
            'lGestion_id'=>'required',
            'lMinimo'=>'required',
            'lMaximo'=>'required',            
            'lCurso_id'=>'required',    
            'lUNegocio_id'=>'required',
            'lNivel'=>'required',
        ]);          
        
        DB::select('call pGrupos (0,?,?,?,?,?,?,?,?,?,1)',
        [$request->input('sGrupo'), $request->input('lGestion_id'), $request->input('lMinimo'),
        $request->input('lMaximo'), 0, $request->input('lCurso_id'), 1, $request->input('lUNegocio_id'),$request->input('lNivel') ]);        
        return redirect()->route('grupos.index')
                        ->with('success','Grupo CREADO correctamente.');
    }
    public function show($id)
    {
        $grupos = DB::select('call pGrupos(?,null,null,null,null,null,null,null,null,null,5)',[decrypt($id)]);// Concepto::find(decrypt($id));
        return view('grupos.show', compact('grupos'));
    }
    public function reporte($id)
    {           
        $unegocios = DB::select('call pUnegocios (?,null,null,null,null,null,null,null,null,null,7)',[session('UNegocioID')]);
        $grupos = DB::select('call pGrupos(?,null,?,null,null,null,null,null,?,null,5)',[decrypt($id), session('GestionID'), session('UNegocioID')]);
        $pdf= PDF:: loadView('transacciones.reporte', compact('grupos','unegocios'));
        return $pdf->stream(); 
    }
    public function edit($id)
    {
        $cboEstados = DB::select("call pvalGrupos(3,'boolEstado Grupo',6)");
        $cboNiveles = DB::select("call pvalGrupos(2,'boolEstado Grupo',6)");
        $cboGestiones = Gestion::all();
        $cboCursos = Curso::all();
        $cboUNegocios = UNegocio::all();        
        $grupos = Grupo::find(decrypt($id)); // DB::select('call pGrupos(?,null,null,null,null,null,null,null,null,null,5)',[decrypt($id)]);
        //dd($grupos);
        //dd($combobox);
        return view('grupos.edit', compact('grupos','cboEstados','cboNiveles','cboGestiones','cboCursos', 'cboUNegocios'));
    }

    public function update(Request $request)
    {
        $request->validate([  
            'lGrupo_id' => 'required',
            'sGrupo' => 'required',
            'lGestion_id'=>'required',
            'lMinimo'=>'required',
            'lMaximo'=>'required',    
            'lActual'=> 'required',        
            'lCurso_id'=>'required', 
            'boolEstado'=> 'required',   
            'lUNegocio_id'=>'required',
            'lNivel'=>'required',
        ]); 
        // Lógica para actualizar un grupo en la base de datos
        DB::select('call pGrupos(?,?,?,?,?,?,?,?,?,?,2)', 
            [$request->input('lGrupo_id'),
            $request->input('sGrupo'),
            $request->input('lGestion_id'),
            $request->input('lMinimo'),
            $request->input('lMaximo'),
            $request->input('lActual'),
            $request->input('lCurso_id'),
            $request->input('boolEstado'),
            $request->input('lUNegocio_id'),
            $request->input('lNivel'),
            ]);
        return redirect()->route('grupos.index')
            ->with('success','Grupo actualizado');
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar grupo de la base de datos
        $combobox = DB::select("call pvalGrupos(2,'lNivel',6)");
        DB::select('call pGrupos(?,null,null,null,null,null,null,null,null,null,3)',[$id]);
        $grupos = DB::select('call pGrupos(0,null,null,null,null,null,null,null,null,null,4)');
        return view('grupos.index', compact('grupos','combobox'));
    }
}