<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB; 
use App\Models\Gestion;
use Illuminate\Http\Request;

class GestionController extends Controller
{
    public function index()
    {
        //$gestiones = Gestion::all();
        //return view('gestiones.index', compact('gestiones'));
        $gestiones = DB::select('call pGestiones (0,null,null,null,null,null,0,4)');
        //dd($gestiones);
        return view('gestiones.index', compact('gestiones'));        
    }

    public function create()
    {
        return view('gestiones.create');
    }

    public function store(Request $request)
    {
        // Lógica para almacenar una nueva gestión en la base de datos
        $request->validate([
            'sGestion' => 'required|max:4, Rule::unique("Gestiones")',
            'dtInicio' => 'required',
            'dtFinal' => 'required',
            'lMeses' => 'required',            
            'sDescripcion' => 'required',
        ]);
        Gestion::create($request->all());
        return redirect()->route('gestiones.index')
                        ->with('success','Gestión creada correctamente.');
    }

    public function show($idGestion)
    {
        //$gestion = DB::select('call pGestiones (?,null,null,null,0,null,0,5)',[$idGestion]);
        $gestion = Gestion::find(decrypt($idGestion));
        //dd($gestion);
        return view('gestiones.show', compact('gestion'));        
    }

    public function edit($id)
    {        
        //$gestion=Gestion::findOrFail($gestion);
        /*return $gestion;*/
        $gestion=Gestion::find(decrypt($id));
        return view('gestiones.edit', compact('gestion'));
    }

    public function update(Request $request, Gestion $gestion)
    {
        // Lógica para actualizar una gestión en la base de datos
        /*
        $gestion->lGestion_id = $request->input('lGestion_id');
        $gestion->sGestion = $request->input('sGestion');
        $gestion->dtInicio = $request->input('dtInicio');
        $gestion->dtFinal = $request->input('dtFinal');
        $gestion->lMeses = $request->input('lMeses');
        $gestion->boolEstado = $request->input('boolEstado');
        $gestion->sDescripcion = $request->input('sDescripcion');        
        */        
        //dd($gestion);
        DB::select('call pGestiones (?,?,?,?,?,?,?,2)',[$request->input('lGestion_id'),
            $request->input('sGestion'),$request->input('dtInicio'),
            $request->input('dtFinal'),($request->input('boolEstado')? 1 : 0),
            $request->input('sDescripcion'),$request->input('lMeses')]);
        //$gestion->update($request->all());
        return redirect()->route('gestiones.index')
                        ->with('success','Gestiones actualizadas.');
    }

    public function destroy(Request $request, $idGestion)
    {
        // Lógica para eliminar una gestión de la base de datos        
        DB::select('call pGestiones (?,null,null,null,null,null,null,3)',[$idGestion]);
        //dd($idGestion);
        $gestiones = DB::select('call pGestiones (0,null,null,null,0,null,0,4)');
        //dd($gestiones);
        return view('gestiones.index', compact('gestiones')); 
        
    }
}