<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use App\Models\Estudiante;
use App\Models\UNegocio;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
class EstudianteController extends Controller
{
    public function index(Request $request)
    {   
        $ValorBusqueda = $request->flBuscar;
        $estudiantes = DB::select('call pEstudiantes(0,null,?,null,?,null,null,null,null,null,null,?)',[$ValorBusqueda == null ? null:$ValorBusqueda, (int)session('UNegocioID'), $ValorBusqueda == null ? 4:7]);//Estudiante::all();
        return view('estudiantes.index', compact('estudiantes'));
    }

    public function create()
    {
        $cboUNegocios = UNegocio::where('boolEstado','=',1)->where('lUNegocio_id','=',session('UNegocioID'))->get();
        return view('estudiantes.create', compact('cboUNegocios'));
    }

    public function store(Request $request)
    {
        $request ->validate([
            'sNombre'=> 'required',
            'sApellido'=> 'required',
            'sEmail'=> 'required',
            'sPassword'=> 'required',
            'lUNegocio_id'=> 'required',            
        ]);
        // Lógica para almacenar un nuevo estudiante en la base de datos
        $codigo = $request->input('sCodigo')== null ? 0:$request->input('sCodigo');        
        // Scrip para subir o mover imagen        
        if ($request->hasFile("sFoto")){
            $imagen = $request->file("sFoto");
            //$nombreimagen = Str::slug($request->sApellido) .'.'. $imagen->guessExtension();            
            $nombreimagen = Str::slug(substr($request->sEmail,0,strpos($request->sEmail,'@'))) .'.'. $imagen->guessExtension();            
            $ruta = public_path("img/student/");

            //sto es com move
            //$imagen->move($ruta,$nombreimagen);
            copy($imagen->getRealPath(),$ruta.$nombreimagen);
            $foto = $nombreimagen;
        }
        else
            {
                $foto = 'user-default.jpg';
            }
        DB::select('call pEstudiantes(0,?,?,?,?,?,?,?,?,null,?,1)',[$codigo, $request->input('sNombre'), $request->input('sApellido'),
            $request->input('lUNegocio_id'), $request->input('sEmail'), md5($request->input('sPassword')), $foto,1, $request->input('sRude')]);
        return redirect()->route('estudiantes.index')
            ->with('success', 'Estudiante creado correctamente');
    }

    public function show($id)
    {   $estudiantes = new Estudiante();
        $estudiantes = DB::select('call pEstudiantes(?,null,null,null,null,null,null,null,null,null,null,5)',[decrypt($id)]);        
        return view('estudiantes.show', compact('estudiantes'));
    }

    public function edit($id)
    {
        $cboUNegocios = UNegocio::where('boolEstado','=',1)->where('lUNegocio_id','=',session('UNegocioID'))->get();
        $estudiantes = Estudiante::find(decrypt($id));
        return view('estudiantes.edit', compact('estudiantes', 'cboUNegocios'));
    }

    public function update(Request $request)
    {
        $request ->validate([
            'sNombre'=> 'required',
            'sApellido'=> 'required',
            'sEmail'=> 'required',
            'sPassword'=> 'required',
            'lUNegocio_id'=> 'required',            
        ]);
        $password = $request->input('chec')? md5($request->input('sPassword')): $request->input('sPassword');
        $codigo = $request->input('sCodigo')== null ? 0:$request->input('sCodigo');   
        if ($request->hasFile("sFoto")){
            $imagen = $request->file("sFoto");
            if ($request->input('sLogo')=='user-default.jpg'){$nombreimagen = Str::slug(substr($request->sEmail,0,strpos($request->sEmail,'@'))) .'.'. $imagen->guessExtension();}
            else{$nombreimagen = $request->input('sLogo');} 
            
            $ruta = public_path("img/student/");
            //sto es com move
            //$imagen->move($ruta,$nombreimagen);
            copy($imagen->getRealPath(),$ruta.$nombreimagen);
            $foto = $nombreimagen;
        }
        else {$foto=Null;}
        // Lógica para actualizar un estudiante en la base de datos
        DB::select('call pEstudiantes(?,?,?,?,?,?,?,?,?,null,?,2)',
            [$request->input('lEstudiante_id'),
            $codigo,
            $request->input('sNombre'),
            $request->input('sApellido'),
            $request->input('lUNegocio_id'),
            $request->input('sEmail'),
            $password,
            $foto,
            ($request->input('boolEstado')? 1 : 0),
            $request->input('sRude'),
        ]);
        return redirect()->route('estudiantes.index')
            ->with('success', 'Estudiante antualizado');
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar un estudiante de la base de datos
        DB::select('call pEstudiantes(?,null,null,null,null,null,null,null,null,null,null,3)',[$id]);
        return($this->index($request));
    }
}