<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use App\Models\Gestion;
use App\Models\Concepto;
use App\Models\DConcepto;
use App\Models\UNegocio;
use Illuminate\Http\Request;

class DConceptoController extends Controller
{
    public function index()
    {
        $dconceptos = DB::select('call pDconceptos(0,null,null,null,null,null,4)') ; //DConcepto::all();
        return view('dconceptos.index', compact('dconceptos'));
    }

    public function create()
    {
        $cboTipoDConceptos =DB::select("call pvalGrupos(5,'lTipoDConcepto',6)");
        $cboGestiones = Gestion::where('boolEstado','=',1)->orderBy('sGestion','ASC') ->get();        
        $cboConceptos = DB::select('call pConceptos(0,null,null,1,4)');        
        $cboUNegocios = UNegocio::where('boolEstado','=',1)->orderBY('sDescripcion','ASC') ->get();
        return view('dconceptos.create', compact('cboTipoDConceptos', 'cboGestiones', 'cboConceptos', 'cboUNegocios'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo detalle de concepto en la base de datos
        $request->validate([
            'lMonto'=> 'required',
            'lTipoDConcepto'=>'required',
            'lGestion_id'=>'required',
            'lConcepto_id'=>'required',
            'lUNegocio_id'=>'required',
        ]);
        DB::select('call pDconceptos(0,?,?,?,?,?,1)',[
            $request->input('lMonto'), $request->input('lTipoDConcepto'),
            $request->input('lGestion_id'), $request->input('lConcepto_id'), $request->input('lUNegocio_id'),
        ]);
        return redirect()->route('dconceptos.index') ->with('success','Registro Creado correctamente');
    }

    public function show($id)
    {
        $dconceptos =DB::select('call pDconceptos(?, null, null, null, null, null, 5)', [decrypt($id)]);        
        return view('dconceptos.show', compact('dconceptos'));
    }

    public function edit($id)
    {
        $cboTipoDConceptos =DB::select("call pvalGrupos(5,'lTipoDConcepto',6)");
        $cboGestiones = Gestion::where('boolEstado','=',1)->orderBy('sGestion','ASC') ->get();
        $cboConceptos = DB::select('call pConceptos(0,null,null,1,4)');
        $cboUNegocios = UNegocio::where('boolEstado','=',1)->orderBY('sDescripcion','ASC') ->get();
        $dconceptos = DConcepto::find(decrypt($id));
        return view('dconceptos.edit', compact('dconceptos','cboTipoDConceptos', 'cboGestiones', 'cboConceptos', 'cboUNegocios'));
    }

    public function update(Request $request)
    {
        // Lógica para actualizar un detalle de concepto en la base de datos
        $request->validate([
            'lDConcepto_id'=> 'required',
            'lMonto'=> 'required',
            'lTipoDConcepto'=>'required',
            'lGestion_id'=>'required',
            'lConcepto_id'=>'required',
            'lUNegocio_id'=>'required',
        ]);
        DB::select('call pDconceptos(?,?,?,?,?,?,2)',[ $request->input('lDConcepto_id'),
            $request->input('lMonto'), $request->input('lTipoDConcepto'),
            $request->input('lGestion_id'), $request->input('lConcepto_id'), $request->input('lUNegocio_id'),
        ]);
        return redirect()->route('dconceptos.index') ->with('success','Registro Modificado correctamente');    
    }

    public function destroy($id)
    {
        // Lógica para eliminar un detalle de concepto de la base de datos
        DB::select('call pDconceptos(?,null,null,null,null,null,3)', [$id]);
        return($this->index());
    }
}