<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use App\Models\Curso;
use Illuminate\Http\Request;

class CursoController extends Controller
{
    public function index()
    {          
        $cursos = DB::select('call pCursos(0,null,null,4)'); 
        return view('cursos.index', compact('cursos'));
    }

    public function create()
    {        
        return view('cursos.create');
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo curso en la base de datos
        $request->validate([
            'sCurso'=> 'required',            
        ]);
        DB::select('call pCursos(0,?,?,1)',[$request->input('sCurso'),$request->input('sDescripcion')]);
        return redirect()->route('cursos.index')
        ->with('success','Curso CREADO correctamente.');
    }

    public function show($id)
    {
        $curso = DB::select('call pCursos(?,null,null,5)',[decrypt($id)]);
        return view('cursos.show', compact('curso'));
    }

    public function edit($id)
    {        
        $curso = Curso::find(decrypt($id)); //  DB::select('call pCursos(?,null,null,null,5)',[decrypt($id)]);
        //dd($curso);
        return view('cursos.edit', compact('curso'));
    }

    public function update(Request $request)
    {
        // Lógica para actualizar un curso en la base de datos
        DB::select('call pCursos(?,?,?,2)',[
            $request->input('lCurso_id'),
            $request->input('sCurso'),
            $request->input('sDescripcion'),
        ]);
        return redirect()->route('cursos.index')
        ->with('success','Curso ACTUALIZADO correctamente');
    }

    public function destroy($id)
    {
        // Lógica para eliminar un curso de la base de datos
        //DB::select('call pCursos(?,null,null,null,3)',[decrypt($id)]);
        $cursos = DB::select('call pCursos(0,null,null,4)');
        return view('cursos.index', compact('cursos'));
    }
}