<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB; 
use App\Models\Concepto;
use Illuminate\Http\Request;

class ConceptoController extends Controller
{
    public function index()
    {
        //dd(auth()->user()->lRol_id);
        //dd(auth()->user()->name);
        //dd(auth()->user());
        
        $conceptos = DB::select('call pConceptos (0,null,null,null,4)'); // Concepto::all();        
        return view('conceptos.index', compact('conceptos'));
    }

    public function create()
    {
        $combobox = DB::select("call pvalGrupos(1,'lTipoConcepto',6)"); //ValGrupo::all(); //         
        return view('conceptos.create', compact('combobox'));
    }

    public function store(Request $request)
    {
        // Lógica para almacenar un nuevo concepto en la base de datos
        $request->validate([                      
            'sConcepto' => 'required',
            'lTipoConcepto'=>'required',
        ]);        
        $concepto = DB::select('call pConceptos (0,?,?,?,1)',[$request->input('sConcepto'), $request->input('lTipoConcepto'),1]);        
        return redirect()->route('conceptos.index')
                        ->with('success','Concepto creada correctamente.');
    }

    public function show($id)
    {
        $concepto = DB::select('call pConceptos(?,null,null,null,5)',[decrypt($id)]);// Concepto::find(decrypt($id));
        return view('conceptos.show', compact('concepto'));
    }

    public function edit($id)
    {
        //$concepto = Concepto::findOrFail($concepto);                
        //$concepto = DB::select('call pConceptos(?,null,null,null,5)',[$id]);
        //dd($concepto);  leer FakeID
        $combobox = DB::select("call pvalGrupos(1,'lTipoConcepto',6)");
        $concepto=Concepto::find(decrypt($id));       
        return view('conceptos.edit', compact('concepto','combobox'));
    }

    public function update(Request $request)
    {
        // Lógica para actualizar un concepto en la base de datos
        DB::select('call pconceptos(?,?,?,?,2)', 
            [$request->input('lConcepto_id'),
            $request->input('sConcepto'),
            $request->input('lTipoConcepto'),
            ($request->input('boolEstado')? 1 : 0)
            ]);
        return redirect()->route('conceptos.index')
            ->with('success','Conceptos actualizados');
    }

    public function destroy(Request $request, $id)
    {
        // Lógica para eliminar un concepto de la base de datos
        DB::select('call pConceptos(?,null,null,null,3)',[$id]);
        $conceptos = DB::select('call pConceptos(0,null,null,null,4)');
        return view('conceptos.index', compact('conceptos'));
    }
}
